import yaml
import atexit
import os
from pathlib import Path

class Book:
    def __init__(self, bid, name, price, summary):
        self.bid = bid
        self.name = name
        self.price = price
        self.summary = summary
    def __str__(self):
        return f"编号:{self.bid}---书名:{self.name}---价格:{self.price}---简介:{self.summary}"
class BookManagement:
    def __init__(self):
        self.__books = []
        bookslist = load_data()
        if len(bookslist) > 0:
            for b in bookslist:
                book = Book(b["bid"], b["name"], b["price"], b["summary"])
                self.__books.append(book)
        print(self.__books)
    def __menu(self):
        """
        菜单函数：展示图书管理系统菜单信息，并获取用户输入
        :return: 用户输入的编号字符串
        :return:
        """
        print("*****************************")
        print("*      图书管理系统           *")
        print("* 1. 添加新图书信息           *")
        print("* 2. 通过编号修改图书信息      *")
        print("* 3. 通过编号删除图书信息      *")
        print("* 4. 通过书名删除图书信息      *")
        print("* 5. 通过编号查询图书信息      *")
        print("* 6. 通过书名查询图书信息      *")
        print("* 7. 显示所有图书信息         *")
        print("* 8. 退出系统                *")
        print("*****************************")
        select_op = input("请输入编号选择操作:")
        return select_op

    def __get_bid(self):
        """
        获取输入的图书编号
        :return: 返回编号字符串
        """
        bid = input("请输入图书ID：")
        return bid
    def __get_name(self):
        """
        获取输入的书名
        :return: 返回书名字符串
        """
        name = input("请输入书名：")
        return name
    def __get_price(self):
        '''
        获取输入的价格
        :return: 返回价格
        '''
        while True:
            price = input("请输入图书价格：")
            if price.isdigit():
                return int(price)
            else:
                print("输入价格，请输入数字")
    def __get_summary(self):
        '''
        获取输入的图书简介
        :return: 返回图书简介字符串
        '''
        summary = input("请输入图书简介：")
        return summary
    def add_book(self, bid, name, price, summary):
        """
        添加图书方法
        :param bid: 编号
        :param name: 书名
        :param price: 价格
        :param summary: 简介
        :return: 操作提示
        """
        for book in self.__books:
            if book.bid == bid:
                print("图书编号已存在")
                return "添加失败"
        else:
            book = Book(bid, name, price, summary)
            self.__books.append(book)
            print("添加图书信息成功")
            return "添加成功"
    def modify_book_by_id(self, bid):
        """
        通过编号修改图书信息方法
        :param bid:图书编号
        :return:操作提示
        """
        for book in self.__books:
            if book.bid == bid:
                book.name = self.__get_name()
                book.price = self.__get_price()
                book.summary = self.__get_summary()
                print("修改图书信息成功")
                return "修改成功"
        else:
            print(f"没有{bid}对应的图书信息")
            return "修改失败"
    def delete_book_by_id(self, bid):
        """
        通过编号删除图书
        :param bid: 图书编号
        :return: 操作提示
        """
        for book in self.__books:
            if book.bid == bid:
                self.__books.remove(book)
                print("删除成功")
                return "删除成功"
        else:
            print(f"没有{bid}对应的学生信息")
            return "删除失败"
    def delete_book_by_name(self, name):
        """
        通过书名删除图书方法
        :param name:书名
        :return:操作提示
        """
        exist_b = []
        for book in self.__books:
            if book.name == name:
                exist_b.append(book)
        if len(exist_b) > 0:
            for b in exist_b:
                self.__books.remove(b)
                print(f"书名为【{name}】的图书删除成功")
            else:
                print(f"成功删除{len(exist_b)}个书名为【{name}】的图书")
                return "删除成功"
        else:
            print(f"图书【{name}】不存在，无法删除")
            return "删除失败"
    def query_book_by_id(self, bid):
        """
        通过编号查询图书
        :param bid:图书编号
        :return:操作提示
        """
        for book in self.__books:
            if book.bid == bid:
                print(f"编号为【{book.bid}】的图书信息如下")
                print(f"编号:{book.bid}---书名:{book.name}---价格:{book.price}---简介:{book.summary}")
                return "查询成功"
        else:
            print(f"编号 {bid} 的图书不存在")
            return "查询失败"
    def query_book_by_name(self, name):
        """
        通过书名查询图书
        :param name:书名
        :return:操作提示
        """
        exist_b = []
        for book in self.__books:
            if book.name == name:
                exist_b.append(book)
        if len(exist_b) > 0:
            print(f"书名为【{name}】的图书共有{len(exist_b)}本, 信息如下：")
            for b in exist_b:
                print(f"编号:{b.bid}---书名:{b.name}---价格:{b.price}---简介:{b.summary}")
            return "查询成功"
        else:
            print(f"图书【{name}】不存在")
            return "查询失败"
    def show(self):
        """
        显示所有图书信息
        """
        print("所有图书信息如下：")
        for book in self.__books:
            print(f"编号:{book.bid}---书名:{book.name}---价格:{book.price}---简介:{book.summary}")
    def save_data(self):
        """
        数据存储到本地
        """
        booksnew = []
        for book in self.__books:
            book_dict = vars(book)
            booksnew.append(book_dict)
        with open('book_data.yaml', 'w', encoding='utf-8') as file:
            # 使用 default_flow_style=False 保证块格式（换行+缩进）
            yaml.dump(booksnew, file, allow_unicode=True, default_flow_style=False)
    def manager(self):
        """
        管理方法
        """
        while True:
            select_op = self.__menu()
            if len(select_op) ==1 and select_op in "12345678":
                if select_op == "1":
                    bid = self.__get_bid()
                    name = self.__get_name()
                    price = self.__get_price()
                    summary = self.__get_summary()
                    self.add_book(bid, name, price, summary)
                elif select_op == "2":
                    bid = self.__get_bid()
                    self.modify_book_by_id(bid)
                elif select_op == "3":
                    bid = self.__get_bid()
                    self.delete_book_by_id(bid)
                elif select_op == "4":
                    name = self.__get_name()
                    self.delete_book_by_name(name)
                elif select_op == "5":
                    bid = self.__get_bid()
                    self.query_book_by_id(bid)
                elif select_op == "6":
                    name = self.__get_name()
                    self.query_book_by_name(name)
                elif select_op == "7":
                    self.show()
                else:
                    self.save_data()
                    break
            else:
                print("输入的数据不合法，请输入在合法范围内的操作编号！！！")


def load_data():
    """加载 YAML 文件数据，若文件不存在则返回空列表"""
    file_path = Path('book_data.yaml')
    try:
        with open(file_path, 'r', encoding='utf-8') as file:
            return yaml.safe_load(file) or []
    except FileNotFoundError:
        return []
    except Exception as e:
        print(f"数据加载异常: {str(e)}")
        return []

if __name__ == '__main__':
    book_manager = BookManagement()
    book_manager.manager()













