# 图书管理系统
# 图书类：
class Book:
    def __init__(self, bid, name, price, summary):
        self.bid = bid
        self.name = name
        self.price = price
        self.summary = summary
    def __str__(self):
        return f'编号：{self.bid}, 书名：{self.name}, 价格：{self.price}, 简介：{self.summary}'

# 管理类
class BookManagement(object):
    def __init__(self):
        # 定义图书列表
        self.__BooksList = []

    '''
    展示菜单
    :return 用户输入的编号
    '''
    def __menu(self):
        print("*****************************")
        print("*      图书管理系统           *")
        print("* 1. 添加新图书信息           *")
        print("* 2. 通过编号修改图书信息      *")
        print("* 3. 通过编号删除图书信息      *")
        print("* 4. 通过书名删除图书信息      *")
        print("* 5. 通过编号查询图书信息      *")
        print("* 6. 通过书名查询图书信息      *")
        print("* 7. 显示所有图书信息         *")
        print("* 8. 退出系统                *")
        print("*****************************")
        select_op = input('请输入菜单中的编号选择操作：')
        return select_op

    def __get_bid(self):
        bid = input('请输入图书的ID：')
        return bid

    def __get_name(self):
        name = input('请输入图书的书名：')
        return name

    def __get_price(self):
        # 输入的价格要是数字且不能为负数
        price = input('请输入图书的价格：')
        while True:
            if price.isdigit() and int(price) > 0:
                # f'(price:.2f)' 格式化浮点法、float()函数
                return int(price)
            else:
                print(f'输入的价格{price}不合法，请输入大于0的数字')


    def __get_summary(self):
        summary = input('请输入图书的简介：')
        return summary

    # 添加图书信息
    def add_book(self,bid,name,price,summary):
        # 如果bid存在，则返回提示信息，如果bid不存在则添加到图书列表中
        for s in self.__BooksList:
            if bid == s.bid:
                print(f'图书{bid}已经存在，添加失败')
                return '添加失败'
        else:
            # 创建一个图书实例
            book = Book(bid,name,price,summary)
            # 把新建的图书添加到图书列表中
            self.__BooksList.append(book)
            # 返回添加成功的提示信息
            print(f'添加图书{book}成功')
            return '添加成功'

    # 通过编号修改图书信息
    def modify_book_by_id(self,bid):
        for s in self.__BooksList:
            if s.bid == bid:
                # 图书存在接收用户输入的信息，进行修改
                name = self.__get_name()
                price = self.__get_price()
                summary = self.__get_summary()
                s.name = name
                s.price = price
                s.summary = summary
                print(f'编号为{bid}的图书修改成功')
                return '修改成功'
        else:
            print(f'编号为{bid}的图书不存在')
            return '修改失败'

    # 通过编号删除图书信息
    def delete_book_by_id(self,bid):
        '''
        通过编号删除图书信息
        :param bid: 接收用户输入的bid
        :return: 返回操作结果
        '''
        for s in self.__BooksList:
            if bid == s.bid:
                self.__BooksList.remove(s)
                print(f'编号为{bid}的图书已经删除')
                return '删除成功'
        else:
            # 返回添加成功的提示信息
            print(f'编号为{bid}的图书不存在，删除失败')
            return '删除失败'

    # 通过书名删除图书信息
    def delete_book_by_name(self,name):
        '''
        判断是否有该图书
        :param name: 接收用户输入的name
        :return: 返回操作结果
        '''
        repeat_book = []
        for s in self.__BooksList:
            if name == s.name:
                repeat_book.append(s)
        if len(repeat_book) > 0:
            for i in repeat_book:
                self.__BooksList.remove(i)
                print(f'名为{name}的图书删除成功')
            else:
                print(f'成功删除{len(repeat_book)}本图书')
                return '删除成功'
        else:
            print(f'名为{name}的图书不存在，删除失败')
            return '删除失败'

    # 通过编号查询图书信息（编号是唯一的）
    def query_book_by_id(self, bid):
        for s in self.__BooksList:
            if s.bid == bid:
                print(f'编号为{bid}的图书信息如下：')
                print(f'编号：{s.bid}, 书名：{s.name}, 价格：{s.price}, 简介：{s.summary}')
                return '查询成功'
        else:
            print(f'编号为{bid}的图书不存在')
            return '查询失败'

    # 通过书名查询图书信息（书名可能会重复）
    def query_book_by_name(self,name):
        query_repeat_book = []
        for i in self.__BooksList:
            if i.name == name:
                query_repeat_book.append(i)
        if len(query_repeat_book) > 0:
            for r in query_repeat_book:
                print(f'名为{name}的图书共有{len(query_repeat_book)}本，信息如下：')
                print(f'编号：{r.bid}, 书名：{r.name}, 价格：{r.price}, 简介：{r.summary}')
            else:
                return '查询成功'
        else:
            print(f'名为{name}的图书不存在，查询失败')
            return '查询失败'

    # 显示所有图书
    def show_all_book(self):
        if len(self.__BooksList) > 0:
            print('所有图书信息如下：')
            for i in self.__BooksList:
                print(f'编号：{i.bid}, 书名：{i.name}, 价格：{i.price}, 简介：{i.summary}')
        else:
            print('暂无图书信息，请添加后再试！')

    # 管理函数：控制整体逻辑
    def manager(self):
        while True:
            # 获取用户输入的编号
            select_op = self.__menu()
            # 判断用户输入的编号是否再1~8之间
            if len(select_op) == 1 and select_op in '12345678':
                # 输入1，完成添加图书操作
                if select_op == '1':
                    # 接收用户输入的图书信息
                    bid = self.__get_bid()
                    name = self.__get_name()
                    price = self.__get_price()
                    summary = self.__get_summary()
                    # 调用添加图书的方法
                    self.add_book(bid, name, price, summary)
                #  输入2，通过编号修改图书
                elif select_op == '2':
                    bid = self.__get_bid()
                    self.modify_book_by_id(bid)
                # 输入3，通过编号删除图书
                elif select_op == '3':
                    bid = self.__get_bid()
                    self.delete_book_by_id(bid)
                # 输入4，通过书名删除图书
                elif select_op == '4':
                    name = self.__get_name()
                    self.delete_book_by_name(name)
                # 输入5，通过编号查询图书
                elif select_op == '5':
                    bid = self.__get_bid()
                    self.query_book_by_id(bid)
                # 输入6，通过书名查询图书
                elif select_op == '6':
                    name = self.__get_name()
                    self.query_book_by_name(name)
                # 输入7，展示所有图书信息
                elif select_op == '7':
                    self.show_all_book()
                # 输入8，退出系统
                else:
                    break
            else:
                print('输入的数据不合法，请在菜单给定的数字中做出选择！！！')


if __name__ == '__main__':
    book = BookManagement()
    book.manager()