import allure
import pytest
from src.books_manager_oop import BookManagement
from utils.util import Utils

def get_yaml_data():
    results = Utils.get_yaml_data('../datas/book_info.yaml')
    datas = results.get('add').get('P0').get('data')
    names = results.get('add').get('P0').get('ids')
    return  datas,names

@pytest.fixture(scope='class')
def bm():
    # 实例化图书对象
    bm = BookManagement()
    yield bm

@allure.feature('图书管理系统')
class TestBooksManager:

    @pytest.mark.parametrize('bid,name,price,summary',
                             # [['s001','《将夜》',52,'一个没有月亮、信仰多元（佛教、昊天道、魔宗、书院）的世界'],
                             #  ['s002','《将夜2》',56,'每隔千年会迎来“永夜”——昊天对人类的清洗机制，目的是维持天地元气平衡并消灭发现世界真相的强者'],
                             #  ['s003','《时空旅人》',65,'fhshfjhskfhskjhfjkshfjkshfjksdhfjsk']],
                             # ids = ['add s001','add s002','add s003']
                             get_yaml_data()[0],
                             ids=get_yaml_data()[1]
                             )
    @pytest.mark.P0
    @allure.story('参数化添加图书')
    @allure.title('参数化添加图书的冒烟测试')
    def test_add_book(self,bm,bid,name,price,summary):
        '''
        测试参数化添加图书
        '''
        with allure.step('调用添加学生的方法'):
            result = bm.add_book(bid,name,price,summary)
        # 断言，实际结果与预期结果做比较
        with allure.step('断言添加结果'):
            assert result == '添加成功'

    @pytest.mark.P1
    @allure.story('修改图书信息')
    @allure.title('修改图书信息的冒烟测试')
    def test_modify_book_by_id(self,bm):
        '''
        测试通过编号修改图书信息
        '''
        result = bm.modify_book_by_id('s001')
        assert result == '修改成功'

    @pytest.mark.P1
    @allure.story('通过id删除图书')
    @allure.title('通过id删除图书的冒烟测试')
    def test_delete_book_by_id(self,bm):
        '''
        测试通过编号删除图书信息
        '''
        result = bm.delete_book_by_id('s001')
        assert result == '删除成功'

    @pytest.mark.P0
    @allure.story('通过id查询图书信息')
    def test_query_book_by_id(self,bm):
        '''
        测试通过编号查询图书信息
        '''
        result = bm.query_book_by_id('s002')
        assert result == '查询成功'



