'''
CREATE TABLE book_xiongyan(
	bid INT PRIMARY KEY AUTO_INCREMENT,
    bname VARCHAR(20),
    price DOUBLE,
    summary VARCHAR(255),
    quantity INT
);
'''
from importlib.metadata import pass_none

from flask import Flask, render_template, request
import pymysql
from werkzeug.utils import redirect

app = Flask(__name__)
# 创建连接数据库对象
db_connect = pymysql.Connect(
    host='mysql.hogwarts.ceshiren.com',
    port=3306,
    user='stu',
    password='hogwarts_stu',
    database='hogwarts_stu',
    charset='utf8'
)

# 定义首页展示（查询）接口
@app.route('/')
def index():
    # 创建游标对象
    cursor = db_connect.cursor()
    sql_str = '''select * from book_xiongyan;'''
    cursor.execute(sql_str)
    books_data = cursor.fetchall()
    # print('图书原数据', books_data)
    books_list = [{'bid': b[0],'bname': b[1], 'price': b[2], 'summary': b[3], 'quantity': b[4]} for b in books_data]
    # print('查询所有图书：', books_list)
    cursor.close()
    return render_template('index.html', books = books_list)

# 定义添加页面接口
@app.route('/add', methods=['GET', 'POST'])
def add():
    if request.method == 'GET':
        return render_template('add.html')
    elif request.method == 'POST':
        books_data = request.form
        # print('添加图书', books_data)
        bname = books_data.get('bname')
        price = books_data.get('price')
        summary = books_data.get('summary')
        quantity = books_data.get('quantity')
        # print('获取值：',bname,price, summary, quantity)
        cursor = db_connect.cursor()
        sql_str = f'''insert into book_xiongyan(bname, price, summary, quantity) values(%s, %s, %s, %s)'''
        # 执行sql
        cursor.execute(sql_str,[bname, price, summary, quantity])
        # 提交新增
        db_connect.commit()
        # 关闭游标
        cursor.close()
        return redirect('/')
    else:
        return '请求方式不正确！'

# 定义修改页面接口
@app.route('/change/<bid>', methods=['GET', 'POST'])
def change(bid):
    if request.method == 'GET':
        cursor = db_connect.cursor()
        sql_str = f'''select * from book_xiongyan where bid = {bid}'''
        cursor.execute(sql_str)
        book_data = cursor.fetchone()
        # 将获取到的图书信息改造成一个字典格式的数据
        book_dic = {'bid': book_data[0],'bname': book_data[1],'price': book_data[2],'summary': book_data[3],'quantity': book_data[4]}
        print('需要修改的图书：', book_data)
        cursor.close()
        return render_template('change.html', book = book_dic)
    elif request.method == 'POST':
        change_data = request.form
        bname = change_data.get('bname')
        price = change_data.get('price')
        summary = change_data.get('summary')
        quantity = change_data.get('quantity')
        print('修改后的数据：',bname, price, summary, quantity)
        cursor = db_connect.cursor()
        sql_str = '''update book_xiongyan set bname = %s, price = %s, summary = %s, quantity = %s where bid = %s'''
        cursor.execute(sql_str, [bname, price, summary, quantity, bid])
        db_connect.commit()
        cursor.close()
        return redirect('/')
    else:
        return '请求方式不正确！'

# 定义删除接口
@app.route('/delete/<bid>')
def delete(bid):
    cursor = db_connect.cursor()
    sql_str = f'''delete from book_xiongyan where bid = {bid} '''
    cursor.execute(sql_str)
    db_connect.commit()
    cursor.close()
    return redirect('/')

if __name__ == '__main__':
    app.run(debug = True, port = 5030)