import yaml
import os

class Book:
    def __init__(self, bid, name, price, summary):
        self.bid = bid
        self.name = name
        self.price = price
        self.summary = summary
    def __str__(self):
        return f"Bid:{self.bid},Name:{self.name},Price:{self.price},Summary:{self.summary}"
class BookManagement:
    def __init__(self):
        self.__book = []
        self._data_file = "student_data.yaml"
        self.load_data()
    def __menu(self):
        print("*****************************")
        print("*      图书管理系统           *")
        print("* 1. 添加新图书信息           *")
        print("* 2. 通过编号修改图书信息      *")
        print("* 3. 通过编号删除图书信息      *")
        print("* 4. 通过书名删除图书信息      *")
        print("* 5. 通过编号查询图书信息      *")
        print("* 6. 通过书名查询图书信息      *")
        print("* 7. 显示所有图书信息         *")
        print("* 8. 退出系统                *")
        print("*****************************")
        select_op = input("请输入编号进行操作：")
        return select_op
    def __get_bid(self):
        return input("请输入编号：")
    def __get_name(self):
        return input("请输入书名：")
    def __get_price(self):
        return int(input("请输入价格："))
    def __get_summary(self):
        return input("请输入简介：")
    def add_book(self, bid, name, price, summary):
        for s in self.__book:
            if s.bid == bid:
                print(f"编号{bid}的书已存在，请勿重复添加！")
                return "添加失败"
        else:
            book = Book(bid, name, price, summary)
            self.__book.append(book)
            print("添加书籍成功")
            return "添加成功"
    def modify_book_by_id(self, bid, name, price, summary):
        for s in self.__book:
            if s.bid == bid:
                s.name = name
                s.price = price
                s.summary = summary
                print("修改成功")
                return
        else:
            print(f"未查询到{bid}的书籍，请重新输入！")
            return
    def delete_book_by_id(self, bid):
        for s in self.__book:
            if s.bid == bid :
                self.__book.remove(s)
                print(f"删除{bid}的书籍成功")
                return
        else:
            print("未查询到书籍，请重新输入！")
            return
    def delete_book_by_name(self, name):
        exsit_s = []
        for s in self.__book:
            if s.name == name:
                exsit_s.append(s)
        if len(exsit_s) > 0:
            for s in exsit_s:
                self.__book.remove(s)
                print(f"删除【{name}】成功")
            else:
                print(f"成功删除{len(exsit_s)}本书")
                return
        else:
            print("未查询到书籍，请重新输入！")
            return
    def query_book_by_id(self, bid):
        for s in self.__book:
            if s.bid == bid:
                print(f"编号:{s.bid},书名:{s.name},价格:{s.price},简介:{s.summary}")
                return
        else:
            print("未查询到书籍，请重新输入！")
            return
    def query_book_by_name(self, name):
        exsit_s =[]
        for s in self.__book:
            if s.name == name:
                exsit_s.append(s)
        if len(exsit_s) > 0:
            for s in exsit_s:
                print(f"编号:{s.bid},书名:{s.name},价格:{s.price},简介:{s.summary}")
        else:
            print("未查询到书籍，请重新输入！")
            return
    def show(self):
        if not self.__book:
            print("暂无书籍")
        else:
            for s in self.__book:
                print(f"编号:{s.bid},书名:{s.name},价格:{s.price},简介:{s.summary}")
    def sava_data(self):
        data = []
        for s in self.__book:
            data.append({'bid': s.bid,
                         'name': s.name,
                         'price': s.price,
                         'summary': s.summary})
            with open(self._data_file, 'w', encoding='UTF-8') as f:
                yaml.dump(data, f, allow_unicode=True)
    def load_data(self):
        if os.path.exists(self._data_file):
            with open(self._data_file, 'r', encoding='UTF-8') as f:
                data = yaml.safe_load(f)
                if data:
                    for item in data:
                        self.__book.append(Book(item['bid'], item['name'], item['price'], item['summary']))
    def manager(self):
        try:
            while True:
                select_op = self.__menu()
                if len(select_op) == 1 and select_op in '12345678':
                    if select_op == '1':
                        sid = self.__get_bid()
                        name = self.__get_name()
                        price = self.__get_price()
                        summary = self.__get_summary()
                        self.add_book(sid, name, price,summary)
                    elif select_op == '2':
                        sid = self.__get_bid()
                        name = self.__get_name()
                        price = self.__get_price()
                        summary = self.__get_summary()
                        self.modify_book_by_id(sid, name, price, summary)
                    elif select_op == '3':
                        bid = self.__get_bid()
                        self.delete_book_by_id(bid)
                    elif select_op == '4':
                        name = self.__get_name()
                        self.delete_book_by_name(name)
                    elif select_op == '5':
                        bid = self.__get_bid()
                        self.query_book_by_id(bid)
                    elif select_op == '6':
                        name = self.__get_name()
                        self.query_book_by_name(name)
                    elif select_op == '7':
                        self.show()
                    else:
                        self.sava_data()
                        print("数据已保存，系统退出")
                        break
                else:
                    print("输入的数据不合法，请重新输入")
                    return
        except Exception as e:
            self.sava_data()
            print(f"程序异常退出，已保存数据：{str(e)}")
if __name__ == '__main__':
    BM = BookManagement()
    BM.manager()





