class Book():
    def __init__(self,bid,name,price,summary):
        self.bid = bid
        self.name = name
        self.price=price
        self.summary=summary
    def __str__(self):
        return f'图书的编号是{self.bid},图书的名字是{self.name},图书的价格是{self.price},图书的简介是{self.summary}'
class BookManager:
    def __init__(self):
        self.books_list=[]
    def __meun(self):
        print("*****************************")
        print("*      图书管理系统           *")
        print("* 1. 添加新图书信息           *")
        print("* 2. 通过编号修改图书信息      *")
        print("* 3. 通过编号删除图书信息      *")
        print("* 4. 通过书名删除图书信息      *")
        print("* 5. 通过编号查询图书信息      *")
        print("* 6. 通过书名查询图书信息      *")
        print("* 7. 显示所有图书信息         *")
        print("* 8. 退出系统                *")
        print("*****************************")
        s = input('请输入您要执行的操作的编号：')
        return s
    def __get_bid(self):
        bid = input('请输入图书编号：')
        return bid
    def __get_name(self):
        name = input('请输入图书名称：')
        return name
    def __get_price(self):
        price = input('请输入对应图书的价格：')
        if price.isdigit():
            return int(price)
        else:
            print('请输入正确的图书价格')
    def __get_summary(self):
        summary = input('请输入图书的简介：')
        return summary
    def add_book(self,bid,name,price,summary):
        for s in self.books_list:
            if s.bid==bid:
                print("输入的图书编号已经存在")
                return '输入失败'
        else:
            s=Book(bid,name,price,summary)
            self.books_list.append(s)
            print("添加图书信息成功")
            return '添加成功'
    def modify_book_by_id(self,bid,name,price,summary):
        for i in self.books_list:
            if i.bid == bid:
                i.name=name
                i.price=price
                i.summary=summary
                print('修改成功')
                return '成功'
        else:
            print('没有找到对应图书信息')
            return '失败'

    def delete_book_by_id(self,s):
        for i in self.books_list:
            if i.bid==s:
                self.books_list.remove(s)
                print('删除成功')
                return '删除成功'
        else:
            print(f'没有找到编号为{s}的图书')
            return '删除失败'

    def delete_book_by_name(self,name):
        delete_books_list=[]
        for i in self.books_list:
            if i.name==name:
                delete_books_list.append(i)
        if len(delete_books_list)>0:
            for i in delete_books_list:
                self.books_list.remove(i)
                print(f'图书名称为{name}的图书删除成功')
            
        else:
            print(f'未找到图书姓名为{name}的图书')
            return '删除失败'
    def query_book_by_id(self,bid):
        for i in self.books_list:
            if i.bid==bid:
                print(f"图书编号：{i.bid}，图书名称：{i.name}，图书价格：{i.price}，图书简介：{i.summary}")
                return '已找到所需图书'
        else:
            print(f'为找到编号为{bid}的图书')
            return '查找失败'
    def query_book_by_name(self,name):
        query_books_list=[]
        for i in self.books_list:
            if i.name==name:
                query_books_list.append(i)
        if len(query_books_list)>0:
            for i in query_books_list:
                print(f"图书编号：{i.bid}，图书名称：{i.name}，图书价格：{i.price}，图书简介：{i.summary}")
            return '查询成功'
        else:
            print(f"书名为 {name} 的图书不存在")
            return '查询失败'
    def show(self):
        if len(self.books_list) > 0:
            for s in self.books_list:
                print(f"图书编号：{s.bid}，书名：{s.name}，图书价格：{s.price}，图书简介：{s.summary}")
                return '已展示全部的图书信息'
        else:
            print('暂时系统中无图书信息')
    def save_data(self):
        pass
    def manage_book(self):
        while True:
            s_op=self.__meun()
            if len(s_op) >0 and s_op in "12345678":
                if s_op =='1':
                    bid = self.__get_bid()
                    name = self.__get_name()
                    price = self.__get_price()
                    summary = self.__get_summary()
                    self.add_book(bid,name,price,summary)
                elif s_op == "2":
                    s=input('请输入要修改的图书编号：')
                    name = self.__get_name()
                    price = self.__get_price()
                    summary = self.__get_summary()
                    self.modify_book_by_id(s,name,price,summary)
                elif s_op == "3":
                    s=input('请输入要删除的图书编号：')
                    self.delete_book_by_id(s)
                elif s_op == "4":
                    s=input('请输入要删除的图书名称：')
                    self.delete_book_by_name(s)
                elif s_op == "5":
                    find_id=input('请输入要查询的图书编号：')
                    self.query_book_by_id(find_id)
                elif s_op == "6":
                    find_name =input('请输入要查询的图书名称：')
                    self.query_book_by_name(find_name)
                elif s_op == "7":
                    self.show()
                elif s_op == "8":
                    break
if __name__ == '__main__':
    s=BookManager()
    s.manage_book()







