"""
__author__='Wang Qing'

"""
class Book:
    def __init__(self, bid, name, price, summary):
        self.bid = bid
        self.name = name
        self.price = price
        self.summary = summary

    def __str__(self):
        return f"图书编号:{self.bid}---书名：{self.name}---价格：{self.price}---简介：{self.summary}"

class BookManagement:
    # 定义一个列表，用来保存图书对象信息
    def __init__(self):
        self.__books = []
    def __menu(self):
        print("*****************************")
        print("*      图书管理系统           *")
        print("* 1. 添加新图书信息           *")
        print("* 2. 通过编号修改图书信息      *")
        print("* 3. 通过编号删除图书信息      *")
        print("* 4. 通过书名删除图书信息      *")
        print("* 5. 通过编号查询图书信息      *")
        print("* 6. 通过书名查询图书信息      *")
        print("* 7. 显示所有图书信息         *")
        print("* 8. 退出系统                *")
        print("*****************************")

        select_number = input("请输入编号选择操作: ")
        return select_number

    def __get_bid(self):
        self.bid = input("请输入图书编号: ")
        return self.bid

    def __get_name(self):
        self.name = input("请输入书名: ")
        return self.name
    def __get_price(self):
        self.price = input("请输入价格: ")
        if self.price.isdigit():
            return self.price
        else:
            print("请输入数字")
            return "输入错误"
    def __get_summary(self):
        self.summary = input("请输入简介: ")
        return self.summary

    def add_book(self, bid, name, price, summary):
        '''
        新增书籍
        :param bid:书籍bid
        :param name:书籍名称
        :param price:书籍价格
        :param summary:书籍简介
        :return:操作信息提示
        '''
        for s in self.__books:
            if s.bid == bid:
                print(f"编号为{s.bid}的书籍已存在，无法再次添加")
                return "添加失败"
        else:
            book = Book(bid, name, price, summary)
            self.__books.append(book)
            print(f"编号为{bid}的书籍添加成功")
            return "书籍添加成功"

    def modify_book_by_id(self, bid, name, price, summary):
        for s in self.__books:
            if s.bid == bid:
                s.name = name
                s.price = price
                s.summary = summary
                print("修改图书信息成功")
                return "修改成功"
        else:
            print(f"没有编号为{bid}的图书，无法修改图书信息")
            return "修改失败"

    def delete_book_by_id(self, bid):
        for s in self.__books:
            if s.bid == bid:
                self.__books.remove(s)
                print("删除成功")
                return "删除成功"

        else:
            print(f"没有编号为{bid}的图书，无法删除")
            return "删除失败"

    def delete_book_by_name(self, name):
        exist_book = []
        for s in self.__books:
            if s.name == name:
                exist_book.append(s)

        if len(exist_book) > 0:
            for s1 in exist_book:
                self.__books.remove(s1)
            print(f"已删除{len(exist_book)}本书")
            return "删除成功"

        else:
            print(f"不存在书名为{name}的书籍，无法删除")
            return "删除失败"

    def query_book_by_id(self, bid):
        for s in self.__books:
            if s.bid == bid:
                print("查询到的图书信息如下：")
                print(f"图书编号：{s.bid}，书名：{s.name}，价格：{s.price}，简介：{s.summary}")
                return "查询成功"
        else:
            print(f"编号为{bid}的图书不存在，查询失败")
            return "查询失败"

    def query_book_by_name(self, name):
        exist_book = []
        for s in self.__books:
            if s.name == name:
                exist_book.append(s)

        if len(exist_book) > 0:
            for s1 in exist_book:
                print(f"图书编号：{s1.bid}，书名：{s1.name}，价格：{s1.price}，简介：{s1.summary}")
                return "查询成功"

        else:
            print(f"不存在书名为{name}的书籍，查询失败")
            return "查询失败"

    def show(self):
        for s in self.__books:
            print("所有图书信息如下：")
            print(f"图书编号：{s.bid}，书名：{s.name}，价格：{s.price}，简介：{s.summary}")



    def manager(self):
        while True:
            select_op = self.__menu()
            if len(select_op) == 1 and select_op in "12345678":
                if select_op == "1":
                    # 获取bid,name,price, summary，并且完成添加新图书
                    bid = self.__get_bid()
                    name = self.__get_name()
                    price = self.__get_price()
                    summary = self.__get_summary()
                    self.add_book(bid, name, price, summary)

                elif select_op == "2":
                # 获取图书编号，修改图书name，price和summary，并且完成修改图书信息操作
                    bid = self.__get_bid()
                    name = self.__get_name()
                    price = self.__get_price()
                    summary = self.__get_summary()
                    self.modify_book_by_id(bid, name, price, summary)

                elif select_op == "3":
                    # 获取图书编号，通过编号删除图书
                    bid = self.__get_bid()
                    self.delete_book_by_id(bid)

                elif select_op == "4":
                    # 获取书名，删除图书信息
                    name = self.__get_name()
                    self.delete_book_by_name(name)

                elif select_op == "5":
                    # 获取编号，查询图书信息
                    bid = self.__get_bid()
                    self.query_book_by_id(bid)
                    pass
                elif select_op == "6":
                    # 获取书名，查询图书信息
                    name = self.__get_name()
                    self.query_book_by_name(name)

                elif select_op == "7":
                    # 显示所有图书信息
                    self.show()

                else:
                    break
            else:
                print("输入有误，请输入1至8之间的数")
                return "输入错误"

if __name__ == '__main__':
    BM = BookManagement()
    BM.manager()