# 定义一个全局变量，用来保存学生的信息，方法各个函数之间进行访问
# {"sid": "s001", "name": "lily", "age": 18, "gender": "female"}
students = []

def menu():
    '''
    菜单函数：展示学生管理系统菜单信息，并获取用户输入
    return: 用户输入的编号字符串
    '''
    print("****************************************")
    print("*                学生管理系统             *")
    print("*        1. 添加新学生信息                 *")
    print("*        2. 通过学号修改学生信息              *")
    print("*        3. 通过学号删除学生信息              *")
    print("*        4. 通过姓名删除学生信息              *")
    print("*        5. 通过学号查询学生信息              *")
    print("*        6. 通过姓名查询学生信息              *")
    print("*        7. 显示所有学生信息               *")
    print("*        8. 退出系统                    *")
    print("****************************************")
    select_op = input("输入编号选择操作：")
    return select_op


def get_sid():
    '''
    获取用户输入的学号
    :return: 返回学号字符串
    '''
    sid = input("请输入学生ID:")
    return sid


def get_name():
    '''
    获取用户输入的姓名
    :return: 返回姓名字符串
    '''
    name = input("请输入学生姓名：")
    return name


def get_age():
    '''
    获取用户输入的年龄
    :return: 返回年龄字符串
    '''
    while True:
        age = input("请输入学生年龄：")
        # 如果输入的为纯数字，返回整数类型的结果
        if age.isdigit():
            return int(age)
        else:
            print("输入年龄不合法，请输入数字")

def get_gender():
    '''
    获取用户输入的性别
    :return: 返回性别字符串
    '''
    gender = input("请输入学生性别：")
    return gender


# 添加学生
def add_student(sid, name, age, gender):
    '''
    添加学生
    :param sid: 学生 id
    :param name: 学生姓名
    :param age: 学生年龄
    :param gender: 学生性别
    :return: 操作提示信息
    '''
    # 遍历学生管理系统列表
    for s in students:
        # 如果学号已经存在，返回失败提示信息
        if s["sid"] == sid:
            print("学号已存在，添加失败")
            return "添加失败"
    else:
        # 拼接学生信息
        student = {"sid": sid, "name": name, "age": age, "gender": gender}
        # 把学生信息存入列表
        students.append(student)
        print("添加学生信息成功")
        # 返回成功提示信息
        return '添加成功'


def modify_student_by_id(sid):
    '''
    通过学号修改学生信息
    :param sid: 学生学号
    :return: 操作提示信息
    '''
    # 遍历学生列表
    for s in students:
        # 如果对应学号的学生存在
        if s["sid"] == sid:
            # 接收用户输入的学生信息
            name = get_name()
            age = get_age()
            gender = get_gender()
            # 给学生信息重新赋值
            s["name"] = name
            s["age"] = age
            s["gender"] = gender
            print("修改成功")
            # 返回成功提示信息
            return "修改成功"
    else:
        print(f'没有 {sid} 对应的学生信息')
        return "修改失败"


def delete_student_by_id(sid):
    '''
    通过ID删除学生信息
    :param sid: 学生学号
    :return: 操作提示信息
    '''
    # 遍历学生列表
    for s in students:
        # 如果对应学号的学生存在
        if s["sid"] == sid:
            students.remove(s)
            print("删除成功")
            return "删除成功"
    else:
        print(f'没有 {sid} 对应的学生信息')
        return "删除失败"


def delete_student_by_name(name):
    '''
    通过学生姓名 删除所有符合的学生
    :param name: 学生姓名
    :return: 操作提示信息
    '''
    exist_s = []
    # 找出所有要删除的学生
    for s in students:
        # 如果对应姓名的学生存在
        if s['name'] == name:
            # 把对应的字典添加到存在学生列表中
            exist_s.append(s)
    # 如果存在列表中有学生数据，开始删除
    if len(exist_s) > 0:
        for s in exist_s:
            students.remove(s)
            print(f"学号 { s['sid'] } 的学生删除成功")
        else:
            print(f"成功删除 {len(exist_s)} 个学生")
            return "删除成功"
    else:
        print("学号不存在，无法删除")
        return "删除失败"


def query_student_by_id(sid):
    '''
    通过学号查询学生信息
    :param sid: 学生学号
    :return: 操作提示信息
    '''
    for s in students:
        if s["sid"] == sid:
            print(f"学号 {sid} 的学生信息如下：")
            print(f"学号：{s.get('sid')}，姓名：{s.get('name')}，年龄：{s.get('age')}，性别：{s.get('gender')}")
            return "查询成功"
    else:
        print(f"学号 {sid} 的学生不存在")
        return "查询失败"


def query_student_by_name(name):
    '''
    通过姓名查询学生信息
    :param name:
    :return: 操作提示信息
    '''
    exist_s = []
    for s in students:
        if s["name"] == name:
            exist_s.append(s)
    if len(exist_s) > 0:
        print(f"姓名为 {name} 的学生共 {len(exist_s)} 名，信息如下：")
        for s in exist_s:
            print(f"学号：{s.get('sid')}，姓名：{s.get('name')}，年龄：{s.get('age')}，性别：{s.get('gender')}")
        return "查询成功"
    else:
        print(f"姓名为 {name} 的学生不存在")
        return "查询失败"


def show():
    '''
    显示所有学生信息
    :return: 格式化的学生信息
    '''
    print("所有学生信息如下：")
    for s in students:
        print(f"学号：{s.get('sid')}，姓名：{s.get('name')}，年龄：{s.get('age')}，性别：{s.get('gender')}")


# 管理函数
def student_manager():
    # 使用死循环展示系统菜单，并根据用户的选择完成操作
    while True:
        # 展示菜单
        select_op = menu()
        # 如果用户输入的选择是1-8之间的单个数字，根据不同选择完成操作
        if len(select_op) == 1 and select_op in "12345678":
            # 输入1完成添加学生操作
            if select_op == "1":
                # 接收用户输入的学生信息：输入学号、姓名、年龄和性别
                sid = get_sid()
                name = get_name()
                age = get_age()
                gender = get_gender()
                add_student(sid, name, age, gender)
            # 输入2完成根据修改学生操作
            elif select_op == "2":
                # 接收用户输入的学生 id
                sid = get_sid()
                modify_student_by_id(sid)
            # 输入3完成通过学生ID删除学生操作
            elif select_op == "3":
                sid = get_sid()
                delete_student_by_id(sid)
            # 输入4完成通过姓名删除学生操作
            elif select_op == "4":
                name = get_name()
                delete_student_by_name(name)
            # 输入5完成通过学生id查询学生操作
            elif select_op == "5":
                sid = get_sid()
                query_student_by_id(sid)
            # 输入6完成通过学生姓名查询学生操作
            elif select_op == "6":
                name = get_name()
                query_student_by_name(name)
            # 输入7完成查询全部学生操作
            elif select_op == "7":
                show()
            # 输入8退出系统
            else:
                break
        else:
            print("输入的数据不合法，请输入在合法范围内的操作编号！！！")


# 程序入口
if __name__ == '__main__':
    # 调用管理系统函数
    student_manager()
