"""
__author__='Wang Qing'

"""
from setuptools.command.egg_info import manifest_maker


# 学生类
class Student:
    def __init__(self, sid, name, age, gender):
        self.sid = sid
        self.name = name
        self.age = age
        self.gender = gender

    def __str__(self):
        return f"sid: {self.sid}---name:{self.name}---age:{self.age}--- gender:{self.gender}"

class StudentManagement:
    # 定义一个实例变量，用来保存学生信息
    def __init__(self):
        self.__students = []
    def __menu(self):
        print("*****************************")
        print("*      学生管理系统           *")
        print("* 1. 添加新学生信息           *")
        print("* 2. 通过学号修改学生信息      *")
        print("* 3. 通过学号删除学生信息      *")
        print("* 4. 通过姓名删除学生信息      *")
        print("* 5. 通过学号查询学生信息      *")
        print("* 6. 通过姓名查询学生信息      *")
        print("* 7. 显示所有学生信息         *")
        print("* 8. 退出系统                *")
        print("*****************************")
        select_op = input("请在菜单中选择要执行的操作")
        return select_op
    # 获取学生信息
    def __get_sid(self):
        self.sid = input("请输入学生的sid:")
        return self.sid
    def __get_name(self):
        name = input("请输入学生的名字:")
        return name
    def __get_age(self):
        age = input("请输入学生的年龄:")
        if age.isdigit():
            return int(age)
        else:
            print("输入的年龄不是全数字，请输入全数字年龄")

    def __get_gender(self):
        gender = input("请输入学生的行性别:")
        return gender

    def add_student(self, sid, name, age, gender):
        # self.sid = sid
        # self.name = name
        # self.age = age
        # self.gender = gender
        for s in self.__students:
            if s.sid == sid:
                print(f"sid为{s.sid}的学生已存在，无法再添加")
                return "添加失败"
        else:
            student = Student(sid, name, age, gender)
            self.__students.append(student)
            print("添加学生信息成功")
            return"添加学生成功"
    def modify_student_by_id(self, sid, name, age, gender):
        for s in self.__students:
            if s.sid == sid:
                s.name = name
                s.age = age
                s.gender = gender
                print(f"修改sid为{sid}的学生信息成功")
                return "修改成功"
        else:
            print("不存在此学生，无法修改")
            return "修改失败"
    def delete_student_by_id(self, sid):
        for s in self.__students:
            if s.sid == sid:
                self.__students.remove(s)
                print("删除成功")
                return "删除成功"
        else:
            print("不存在此学生，无法删除")
            return "删除失败"
    def delete_student_by_name(self, name):
        exist_student = []
        for s in self.__students:
            if s.name == name:
                exist_student.append(s)
        if len(exist_student) > 0:
            for s1 in exist_student:
                self.__students.remove(s1)
                print("名为{name}的学生删除成功")

            print(f"成功删除{len(exist_student)}个学生")
            return "删除成功"
        else:
            print("此学生不存在，无法删除")
            return "删除失败"
    def query_student_by_id(self, sid):
        # 通过学号查询学生信息
        for s in self.__students:
            if s.sid == sid:
                print(f"学号为{s.sid}的学生信息为：学号：{s.sid},姓名：{s.name},年龄：{s.age},性别：{s.gender}")
                return "查询成功"
        else:
            print("学生不存在，查询失败")
            return "查询失败"

    def query_student_by_name(self, name):
        exist_student = []
        for s in self.__students:
            if s.name == name:
                exist_student.append(s)
        if len(exist_student) > 0:
            for s1 in exist_student:
                print(f"学号为{s1.sid}的学生信息为：学号：{s1.sid},姓名：{s1.name},年龄：{s1.age},性别：{s1.gender}")
            print(f"成功查询到{len(exist_student)}个学生的信息")
            return "查询成功"
        else:
            print("此学生不存在，查询")
            return "查询失败"

    def show(self):
        print("所以学生信息如下：")
        for s in self.__students:
            print(f"学号为{s.sid}的学生信息为：学号：{s.sid},姓名：{s.name},年龄：{s.age},性别：{s.gender}")
        # return "查询成功"

    def manager(self):
        while True:
            select_op = self.__menu()
            if len(select_op) == 1 and select_op in "12345678":
                if select_op == "1":
                    sid = self.__get_sid()
                    name = self.__get_name()
                    age = self.__get_age()
                    gender = self.__get_gender()
                    self.add_student(sid, name, age, gender)
                elif select_op == "2":
                    sid = self.__get_sid()
                    name = self.__get_name()
                    age = self.__get_age()
                    gender = self.__get_gender()
                    self.modify_student_by_id(sid, name, age, gender)

                elif select_op == "3":
                    sid = self.__get_sid()
                    self.delete_student_by_id(sid)
                elif select_op == "4":
                    name = self.__get_name()
                    self.delete_student_by_name(name)
                elif select_op == "5":
                    sid = self.__get_sid()
                    self.query_student_by_id(sid)
                elif select_op == "6":
                    name = self.__get_name()
                    self.query_student_by_name(name)
                elif select_op == "7":
                    self.show()
                else:
                    break
            else:
                print("输入的数据不在选项中，请重新输入")

if __name__ == '__main__':
    sm = StudentManagement()
    sm.manager()













