import yaml


class Book:
    def __init__(self, bid, name, price, summary):
        self.bid = bid
        self.name = name
        self.price = price
        self.summary = summary

    def __str__(self):
        return f'书名为：{self.name},价格为：{self.price}，简介为：{self.summary}'


class BookManagement:
    def __init__(self):
        self.book_list = []

    def __get_bid(self):
        bid = input('请输入图书的id：')
        return bid

    def __get_name(self):
        name = input('请输入图书的name：')
        return name

    def __get_price(self):
        price = int(input('请输入图书的price：'))
        return price

    def __get_summary(self):
        summary = input('请输入图书的summary：')
        return summary

    def __menu(self):
        print("*****************************")
        print("*      图书管理系统           *")
        print("* 1. 添加新图书信息           *")
        print("* 2. 通过编号修改图书信息      *")
        print("* 3. 通过编号删除图书信息      *")
        print("* 4. 通过书名删除图书信息      *")
        print("* 5. 通过编号查询图书信息      *")
        print("* 6. 通过书名查询图书信息      *")
        print("* 7. 显示所有图书信息         *")
        print("* 8. 退出系统                *")
        print("*****************************")
        num = input("输入编号选择操作：")
        return num

    def add_book(self, bid, name, price, summary):
        for b in self.book_list:
            if b.bid == bid:
                print('该bid已经存在，请重新输入一个bid')
                return '添加失败'
        else:
            self.book_list.append(Book(bid, name, price, summary))
            print('添加成功')
            return '添加成功'

    def modify_book_by_id(self, bid, name, price, summary):
        for b in self.book_list:
            if b.bid == bid:
                b.name = name
                b.price = price
                b.summary = summary
                print('修改成功')
                return '修改成功'
        else:
            print('输入的图书id不存在')
            return '修改失败'

    def delete_book_by_id(self, bid):
        for b in self.book_list:
            if b.bid == bid:
                self.book_list.remove(b)
                print('删除成功')
                return '删除成功'
        else:
            print('输入的图书id有误，未找到此图书')
            return '删除失败'

    def delete_book_by_name(self, name):
        exist_b = []
        for b in self.book_list:
            if b.name == name:
                exist_b.append(b)
        if len(exist_b) > 0:
            for e in exist_b:
                self.book_list.remove(e)
            print('删除成功')
            return '删除成功'
        else:
            print('输入的图书name有误，未找到此图书')
            return '删除失败'

    def query_book_by_id(self, bid):
        for b in self.book_list:
            if b.bid == bid:
                print(b)
                return '查询成功'
        else:
            print('输入的图书id有误')
            return '查询失败'

    def query_book_by_name(self, name):
        res = []
        for b in self.book_list:
            if b.name == name:
                res.append(b)
        if len(res) > 0:
            for x in res:
                print(f'图书id为：{x.bid}，图书name为：{x.name}')
            return '查询成功'
        else:
            print(f'输入的图书name有误，未找到此图书')
            return '查询失败'

    def show(self):
        for b in self.book_list:
            print(f'图书id：{b.bid}，图书name：{b.name}，图书价格：{b.price}，图书简介：{b.summary}')

    def save_data(self):
        data = []
        for b in self.book_list:
            d = {}
            d['bid'] = b.bid
            d['name'] = b.name
            d['price'] = b.price
            d['summary'] = b.summary
            data.append(d)
        with open('./data/save_data.yaml', 'w') as file:
            yaml.safe_dump(data, file)

    def load_data(self):
        with open('./data/save_data.yaml', encoding='utf-8') as file:
            data = yaml.safe_load(file)
            return data

    def manager(self):
        if self.load_data() != None:
            self.book_list = self.load_data()
        while True:
            num = self.__menu()
            if len(num) == 1 and num in '12345678':
                if num == '1':
                    bid = self.__get_bid()
                    name = self.__get_name()
                    price = self.__get_price()
                    summary = self.__get_summary()
                    self.add_book(bid, name, price, summary)
                elif num == '2':
                    bid = self.__get_bid()
                    name = self.__get_name()
                    price = self.__get_price()
                    summary = self.__get_summary()
                    self.modify_book_by_id(bid, name, price, summary)
                elif num == 3:
                    bid = self.__get_bid()
                    self.delete_book_by_id(bid)
                elif num == '4':
                    name = self.__get_name()
                    self.delete_book_by_name(name)
                elif num == '5':
                    bid = self.__get_bid()
                    self.query_book_by_id(bid)
                elif num == '6':
                    name = self.__get_name()
                    self.query_book_by_name(name)
                elif num == '7':
                    self.show()
                else:
                    self.save_data()
                    break
            else:
                print('输入的编号有误，请重新输入')


if __name__ == '__main__':
    BookManagement().manager()
