import os.path
import re

import yaml
class Book:
    def __init__(self, bid, name, price, summary):
        self.bid = bid
        self.name = name
        self.price = price
        self.summary = summary

    def __str__(self):
        print(f"书本信息如下:\n书本编号:{self.bid},\n书本名称:{self.name},\n书本价格:{self.price},\n书本简介:{self.summary}")


class BookManagement:
    def __init__(self, yamlfile='book_data.yaml'):
        self.yamlfile = yamlfile
        if os.path.exists(self.yamlfile):
            if self.load_yaml():
                self.bookList = self.load_yaml()
            else:
                self.bookList = []

        else:
            self.bookList = []

    def load_yaml(self):
        with open(self.yamlfile, 'r') as file:
            return yaml.safe_load(file)

    def save_to_yaml(self, data, yamlfile='book_data.yaml', readtype='a'):
        with open(yamlfile, readtype, encoding='utf-8') as file:
            yaml.dump(data, file, allow_unicode=True, sort_keys=False)

    def __str__(self):
        res = '\n'.join(map(str, [i for i in self.bookList]))
        return f"总共有{len(self.bookList)}本书.\n{res}"

    def magager(self):
        self.__menu()
        while True:
            number = self.__get_userinput()
            if number == '1':
                bid = self.__get_bid()
                name = self.__get_name()
                price = self.__get_price()
                summary = self.__get_summary()
                self.add_book(bid, name, price, summary)
            elif number == '2':
                self.modify_book_by_id()
            elif number == '3':
                self.delete_book_by_id()
            elif number == '4':
                self.delete_book_by_name()
            elif number == '5':
                self.query_book_by_id()
            elif number == '6':
                self.query_book_by_name()
            elif number == '7':
                self.show()
            else:
                break

    def __menu(self):
        print("*****************************")
        print("*      图书管理系统           *")
        print("* 1. 添加新图书信息           *")
        print("* 2. 通过编号修改图书信息      *")
        print("* 3. 通过编号删除图书信息      *")
        print("* 4. 通过书名删除图书信息      *")
        print("* 5. 通过编号查询图书信息      *")
        print("* 6. 通过书名查询图书信息      *")
        print("* 7. 显示所有图书信息         *")
        print("* 8. 退出系统                *")
        print("*****************************")

    def __get_userinput(self):
        number = input("请输入你需要操作的编号：")
        try:
            if int(number) in range(1, 9):
                return number
            else:
                print('请输入1-8的数字！重新输入！')
                self.__get_userinput()
        except Exception as e:
            print(f"userinput有错误发生{e},请重新输入")
            self.__get_userinput()

    def __get_bid(self):
        bid = input("请输入图书编号,示例：'b001'：")
        try:
            if re.match(r'^[b][0-9]{3}$', bid):
                return bid
            else:
                print("编号格式错误，请重新输入！")
                self.__get_bid()
        except Exception as e:
            print(f"getbid有错误发生{e},请重新输入！")
            self.__get_bid

    def __get_name(self):
        name = input("请输入图书名称：")
        return name

    def __get_price(self):
        price = input("请输入图书的价格：")
        try:
            if price.isdigit():
                return int(price)
            else:
                print('价格应为整型数字，请重新输入！')
                self.__get_price()
        except Exception as e:
            print(f"userinput有错误发生{e},请重新输入")
            self.__get_price()

    def __get_summary(self):
        summary = input("请输入图书简介：")
        return summary

    def add_book(self, bid, name, price, summary):
        for i in self.bookList:
            if i['bid'] == bid:
                print(f"bid为{bid}的书本已存在，请确认！")
                return
        bookitem = {"bid": bid, "name": name, "price": price, "summary": summary}
        self.bookList.append(bookitem)
        self.save_to_yaml([bookitem])
        print("图书添加成功！")
        return

    def modify_book_by_id(self):
        # 通过图书ID修改对应的信息
        # bid唯一
        bid = self.__get_bid()
        for i in self.bookList:
            if i['bid'] == bid:
                name = self.__get_name()
                price = self.__get_price()
                summary = self.__get_summary()
                i['name'] = name
                i['price'] = price
                i['summary'] = summary
                print(f'ID为{bid}的书本信息修改成功')
                self.save_to_yaml(self.bookList, readtype='w')
                return
        print(f"未找到ID为{bid}的书本！请检查！")

    def delete_book_by_id(self):
        bid = self.__get_bid()
        for i in self.bookList:
            if i['bid'] == bid:
                self.bookList.remove(i)
                print(f'ID为{bid}的书本信息删除成功')
                self.save_to_yaml(self.bookList, readtype='w')
                return
        print(f"未找到ID为{bid}的书本！请检查！")

    def delete_book_by_name(self):
        name = self.__get_name()
        duplicateBook = []
        for i in self.bookList:
            if i['name'] == name:
                duplicateBook.append(i)
        if len(duplicateBook) > 1:
            print(f"姓名为{name}有{len(duplicateBook)}位，请通过Id的方式删除！")
        elif len(duplicateBook) == 0:
            print(f"未找到姓名为{name}的图书，请重新确认！")
        else:
            self.bookList.remove(duplicateBook[0])
            self.save_to_yaml(self.bookList, readtype='w')
            print(f'name为{name}的书本信息删除成功')
            return

    def query_book_by_id(self):
        #id不会重复
        bid = self.__get_bid()
        for i in self.bookList:
            if i['bid'] == bid:
                print(f'ID为{bid}的书本信息如下：{i}')

    def query_book_by_name(self):
        #书可能有同名
        name = self.__get_name()
        duplicatebook = []
        for i in self.bookList:
            if i['name'] == name:
                duplicatebook.append(i)
        print(f"name为{name}的图书共有{len(duplicatebook)}本")
        print("\n".join(map(str, [i for i in duplicatebook])))

    def show(self):
        print(f"图书馆共有{len(self.bookList)}本书")
        for i in self.bookList:
            print(i)


if __name__ == "__main__":
    shanghai = BookManagement()

    book1 = Book('b007', '复生六级', 44, '复生六级的简介')
    shanghai.add_book(book1.bid, book1.name, book1.price, book1.summary)
    shanghai.magager()