# !/usr/bin/env python
# -*- coding: utf-8 -*-
"""
@Time    : 2025/2/20 13:33
@Author  : Litianming1.vendor
@File    : book_manager.py
@Desc    : 
"""


class Book:
    def __init__(self, bid, name, price, summary):
        self.bid = bid
        self.name = name
        self.price = price
        self.summary = summary

    def __str__(self):
        return f"BID: {self.bid} --- Name: {self.name} --- Price: {self.price} --- Summaryr: {self.summary}"


# 封装管理类
class BookManagement:

    def __init__(self):
        self.__books = []

    def __menu(self):
        print("*****************************")
        print("*      图书管理系统           *")
        print("* 1. 添加新图书信息           *")
        print("* 2. 通过编号修改图书信息      *")
        print("* 3. 通过编号删除图书信息      *")
        print("* 4. 通过书名删除图书信息      *")
        print("* 5. 通过编号查询图书信息      *")
        print("* 6. 通过书名查询图书信息      *")
        print("* 7. 显示所有图书信息         *")
        print("* 8. 退出系统                *")
        print("*****************************")
        select_op = input("输入编号选择操作：")
        return select_op

    def __get_bid(self):
        sid = input("请输入图书编号ID:")
        return sid

    def __get_name(self):
        name = input("请输入图书名称：")
        return name

    def __get_price(self):
        while True:
            price = input("请输入图书价格：")
            if price.isdigit():
                return int(price)
            else:
                print("输入价格不合法，请输入数字")

    def __get_summary(self):
        gender = input("请输入图书简介：")
        return gender

    def add_book(self, bid, name, price, summary):

        for s in self.__books:
            if s.bid == bid:
                print("图书编号已存在，添加失败")
                return "添加失败"
        else:
            book = Book(bid, name, price, summary)
            self.__books.append(book)
            print("添加图书信息成功")
            return '添加成功'

    def modify_book_by_id(self, bid, name, price, summary):
        for s in self.__books:
            if s.bid == bid:
                s.name = name
                s.price = price
                s.summary = summary
                print("修改成功")
                return "修改成功"
        else:
            print(f'没有 {bid} 对应的图书信息')
            return "修改失败"

    def delete_book_by_id(self, bid):
        for s in self.__books:
            if s.bid == bid:
                self.__books.remove(s)
                print("删除成功")
                return "删除成功"
        else:
            print(f'没有 {bid} 对应的图书信息')
            return "删除失败"

    def delete_book_by_name(self, name):
        exist_s = []
        for s in self.__books:
            if s.name == name:
                exist_s.append(s)

        # 开始删除
        if len(exist_s) > 0:
            for s in exist_s:
                self.__books.remove(s)
                print(f"名称为 { name } 的图书删除成功")
            else:
                print(f"成功删除 {len(exist_s)} 本图书")
                return "删除成功"
        else:
            print(f"图书【{name}】不存在，无法删除")
            return "删除失败"

    def query_book_by_id(self, bid):
        for s in self.__books:
            if s.bid == bid:
                print(f"图书编号 {bid} 的信息如下：")
                print(f"编号：{s.bid}，书名：{s.name}，价格：{s.price}, 简介：{s.summary}")
                return "查询成功"
        else:
            print(f"编号 {bid} 的图书不存在")
            return "查询失败"

    def query_book_by_name(self, name):
        exist_s = []
        for s in self.__books:
            if s.name == name:
                exist_s.append(s)

        if len(exist_s) > 0:
            print(f"书名为 {name} 的图书共 {len(exist_s)} 本，信息如下：")
            for s in exist_s:
                print(f"编号：{s.bid}，书名：{s.name}，价格：{s.price}，简介：{s.summary}")
            return "查询成功"
        else:
            print(f"书名为 {name} 的图书不存在")
            return "查询失败"

    def show(self):
        print("所有图书信息如下：")
        for s in self.__books:
            print(f"编号：{s.bid}，书名：{s.name}，价格：{s.price}，简介：{s.summary}")

    def manager(self):
        '''
        管理方法
        :return:
        '''
        while True:
            select_op = self.__menu()
            if len(select_op) == 1 and select_op in "12345678":
                if select_op == "1":
                    bid = self.__get_bid()
                    name = self.__get_name()
                    price = self.__get_price()
                    summary = self.__get_summary()
                    self.add_book(bid, name, price, summary)
                elif select_op == "2":
                    bid = self.__get_bid()
                    name = self.__get_name()
                    price = self.__get_price()
                    summary = self.__get_summary()
                    self.modify_book_by_id(bid, name, price, summary)
                elif select_op == "3":
                    bid = self.__get_bid()
                    self.delete_book_by_id(bid)
                elif select_op == "4":
                    name = self.__get_name()
                    self.delete_book_by_name(name)
                elif select_op == "5":
                    bid = self.__get_bid()
                    self.query_book_by_id(bid)
                elif select_op == "6":
                    name = self.__get_name()
                    self.query_book_by_name(name)
                elif select_op == "7":
                    self.show()
                else:
                    break
            else:
                print("输入的数据不合法，请输入在合法范围内的操作编号！！！")


# 程序入口
if __name__ == '__main__':
    bm = BookManagement()
    bm.manager()



