"""
编写一个装饰器 log_execution，用于记录函数的执行时间和调用次数。
装饰器应该能够记录每次函数调用的时间、输入参数和返回值，并在函数执行完毕后打印出执行时间和调用次数。
装饰器应该能够应用于任何函数，并在函数执行完毕后打印出调用日志。
"""
import time



def log_execution(func):
    def wrapper(*args, **kwargs):
        start_time = time.time()
        print('开始调用函数：',start_time)
        func(*args, **kwargs)
        print('输入参数', *args,**kwargs)

        end_time = time.time()
        print('结束调用函数',end_time)

        execute_time = end_time - start_time
        print('函数执行时间：',execute_time)

    return wrapper



@log_execution
def sleep(a,b):
    print(f'{a}正在sleeping...')
    time.sleep(1)
    print(f'{b}正在sleeping...')

sleep("cat",'dog')