import pymysql
from flask import Flask, render_template, request
from werkzeug.utils import redirect

app = Flask(__name__)

'''
CREATE TABLE book_ss (
    bid INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(50),
    price FLOAT,
    summary character(20),
    quantity INT
);
INSERT INTO book_ss (bid, name, price, summary, quantity) 
VALUES(1, "书名1","10.12","这是书的概要1",10),
(2, "书名2","20.12","这是书的概要2",20),
(3, "书名3","30.12","这是书的概要3",30),
(4, "书名4","40.12","这是书的概要4",40),
(5, "书名5","50.12","这是书的概要5",50)

'''
db_connect = pymysql.Connect(
    host="mysql.hogwarts.ceshiren.com",
    port=3306,
    user="stu",
    password="hogwarts_stu",
    database="hogwarts_stu",
    charset="utf8"
)


@app.route("/")
def index():
    cursor = db_connect.cursor()
    sql_str = "select * from book_ss;"
    cursor.execute(sql_str)
    datas = cursor.fetchall()
    print(datas)
    cursor.close()
    book_data = [{"bid": book[0], "name": book[1], "price": book[2], "summary": book[3], "quantity": book[4]} for book
                 in datas]

    return render_template("index.html", books=book_data)


@app.route("/add", methods=["GET", "POST"])
def add():
    if request.method == "GET":
        return render_template("add.html")
    else:
        book_info = request.form
        bid = book_info.get("bid")
        name = book_info.get("name")
        price = book_info.get("price")
        summary = book_info.get("summary")
        quantity = book_info.get("quantity")
        cursor = db_connect.cursor()
        sql_str = "INSERT INTO book_ss (bid, name, price, summary, quantity) VALUES(%s,%s,%s,%s,%s);"
        cursor.execute(sql_str, [bid, name, price, summary, quantity])
        db_connect.commit()
        cursor.close()
        return redirect("/")


@app.route("/change/<bid>", methods=["GET", "POST"])
def change(bid):
    if request.method == "GET":
        cursor = db_connect.cursor()
        sql_str = f"select * from book_ss where bid={bid};"
        cursor.execute(sql_str)
        bk = cursor.fetchone()
        book_data = {
            "bid": bk[0],
            "name": bk[1],
            "price": bk[2],
            "summary": bk[3],
            "quantity": bk[4]
        }
        cursor.close()
        return render_template("change.html", book=book_data)
    else:
        book_info = request.form
        name = book_info.get("name")
        price = book_info.get("price")
        summary = book_info.get("summary")
        quantity = book_info.get("quantity")
        cursor = db_connect.cursor()
        sql_str = "update book_ss set name=%s, price=%s, summary=%s, quantity=%s where bid=%s;"
        cursor.execute(sql_str, [name, price, summary, quantity, bid])
        db_connect.commit()
        cursor.close()
        return redirect("/")


# 根据书名，编号，价格范围，概要查询图书，支持单个查询和组合查询
@app.route("/query", methods=["POST"])
def query():
    # 获取查询条件
    search_params = {
        "bid": request.form.get("bid", ""),
        "name": request.form.get("name", ""),
        "price_min": request.form.get("price_min", ""),
        "price_max": request.form.get("price_max", ""),
        "summary": request.form.get("summary", "")
    }

    # 构建查询条件
    conditions = []
    params = []

    if search_params["bid"]:
        conditions.append("bid = %s")
        params.append(search_params["bid"])
    if search_params["name"]:
        conditions.append("name LIKE %s")
        params.append(f"%{search_params['name']}%")
    if search_params["price_min"]:
        conditions.append("price >= %s")
        params.append(search_params["price_min"])
    if search_params["price_max"]:
        conditions.append("price <= %s")
        params.append(search_params["price_max"])
    if search_params["summary"]:
        conditions.append("summary LIKE %s")
        params.append(f"%{search_params['summary']}%")

    # 组装SQL语句
    sql_str = "SELECT * FROM book_ss"
    if conditions:
        sql_str += " WHERE " + " AND ".join(conditions)

    # 执行查询
    cursor = db_connect.cursor()
    cursor.execute(sql_str, params)
    datas = cursor.fetchall()
    cursor.close()

    # 格式化查询结果
    book_data = [
        {
            "bid": book[0],
            "name": book[1],
            "price": book[2],
            "summary": book[3],
            "quantity": book[4]
        }
        for book in datas
    ]

    return render_template("index.html", books=book_data, search_params=search_params)


if __name__ == '__main__':
    app.run(debug=True, port=5056)
