"""
__author__ = 'GDMM'
__desc__ = '管理图书系统'
"""
# 定义图书类: 编号: bid；书名: name；价格: price；简介: summary
class Book:

    # 使用构造函数，接收实例化类的需要传入的参数
    def __init__(self, bid, name, price, summary):
        # 使用实例属性接收传入的值
        self.bid = bid
        self.name = name
        self.price = price
        self.summary = summary

    # 重写对象显示格式的魔法方法
    def __str__(self):
        return f"bid: {self.bid}, name: {self.name}, price: {self.price}, summary: {self.summary}"

# 图书管理类
class BookManager:

    def __init__(self):
        # 准备实例变量，用来保存图书对象
        # 希望只能通过类中的方法来操作，类外面不可以操作
        self.__books = []

    def __menu(self):
        '''
        展示图书管理系统的菜单
        :return: 用户输入的编号的信息
        '''
        print("*****************************")
        print("*      图书管理系统           *")
        print("* 1. 添加新图书信息           *")
        print("* 2. 通过编号修改图书信息      *")
        print("* 3. 通过编号删除图书信息      *")
        print("* 4. 通过书名删除图书信息      *")
        print("* 5. 通过编号查询图书信息      *")
        print("* 6. 通过书名查询图书信息      *")
        print("* 7. 显示所有图书信息         *")
        print("* 8. 退出系统                *")
        print("*****************************")
        # 等待用户输入操作
        # input 返回的都是字符串的类型
        select_op = input("输入菜单中编号选择操作：")
        return select_op

    def __get_bid(self):
        '''
        获取用户输入的图书编号
        :return: 编号字符串 eg. b01
        '''
        bid = input("请输入图书的编号（ID）：")
        return bid

    def __get_name(self):
        '''
        获取用户输入的书名
        :return: 书名的字符串
        '''
        name = input("请输入图书的书名：")
        return name

    def __get_price(self):
        '''
        获取用户输入的价格
        :return: 价格（整数类型）
        '''
        while True:
            price = input("请输入图书的价格：")
            # 如果输入的是纯数字，返回整数类型的结果
            if price.isdigit():
                return int(price)
            else:
                print(f"输入的价格 {price} 不合法，请输入数字！！！")

    def __get_summary(self):
        '''
        获取用户输入的简介
        :return: 简介字符串
        '''
        summary = input("请输入图书简介：")
        return summary

    def add_book(self, bid, name, price, summary):
        '''
        添加图书
        :param bid: 图书的编号
        :param name: 图书的书名
        :param price: 图书的价格
        :param summary: 图书的简介
        :return: 操作结果信息
        '''
        # 如果图书存在，不添加数据，展示提示信息
        for b in self.__books:
            # 如果编号已经存在，返回失败提示信息
            if b.bid == bid:
                print("图书已经存在，添加失败")
                return "添加失败"
        else:
            # 获取图书的对象
            book = Book(bid, name, price, summary)
            # 把图书数据存入列表
            self.__books.append(book)
            print(f"添加图书 {book} 成功")
            # 返回操作结果
            return "添加成功"

    def modify_book_by_id(self, bid):
        '''
        通过编号修改图书信息
        :param bid: 图书的编号
        :return: 操作结果
        '''
        for b in self.__books:
            if b.bid == bid:
                # 接收用户输入的图书信息
                name = self.__get_name()
                price = self.__get_price()
                summary = self.__get_summary()
                # 修改对应图书对象的属性
                b.name = name
                b.price = price
                b.summary = summary
                print(f"编号为 {bid} 图书信息修改成功！")
                return "修改成功"
        else:
            print(f"没有编号为 {bid} 对应的图书信息")
            return "修改失败"

    def delete_book_by_id(self, bid):
        '''
        通过编号删除图书
        :param bid: 图书的编号
        :return: 操作的结果
        '''
        for b in self.__books:
            if b.bid == bid:
                self.__books.remove(b)
                print(f"图书 {b} 删除成功")
                return "删除成功"
        else:
            print(f"没有编号为 {bid} 对应的图书")
            return "删除失败"

    def delete_book_by_name(self, name):
        '''
        通过图书名删除图书
        :param name: 图书名
        :return: 操作结果
        '''
        # 所有通过书名找到的图书列表
        exist_book = []
        for b in self.__books:
            if b.name == name:
                # 把对应的图书存到找到的图书列表中
                exist_book.append(b)
        # 如果列表不为空，开始删除图书
        if len(exist_book) > 0:
            for boo in exist_book:
                self.__books.remove(boo)
                print(f"编号为 {boo.bid} 的图书删除成功")
            else:
                print(f"成功删除了 {len(exist_book)} 个图书")
                return "删除成功"
        else:
            print(f"图书名为 {name} 的图书不存在，无法删除！！！")
            return "删除失败"

    def query_book_by_id(self, bid):
        '''
        通过编号查询图书信息
        :param bid: 图书的编号
        :return: 操作结果
        '''
        for b in self.__books:
            if b.bid == bid:
                print(f"编号为 {bid} 的图书信息如下：")
                print(f"编号：{b.bid}，书名：{b.name}，价格：{b.price}，简介：{b.summary}")
                return "查询成功"
        else:
            print(f"编号为 {bid} 的图书不存在")
            return "查询失败"

    def query_book_by_name(self, name):
        '''
        通过图书名查询图书
        :param name: 图书名
        :return:
        '''
        # 所有通过书名找到的图书的列表
        exist_book = []
        for b in self.__books:
            if b.name == name:
                # 把对应的图书存到找到的图书列表中
                exist_book.append(b)
        # 如果列表不为空，展示图书信息
        if len(exist_book) > 0:
            print(f"书名为 {name} 的图书共有 {len(exist_book)} 名，信息如下：")
            for s in exist_book:
                print(f"编号：{b.bid}，书名：{b.name}，价格：{b.price}，简介：{b.summary}")
            return "查询成功"
        else:
            print(f"图书名为 {name} 的图书不存在！！！")
            return "查询失败"

    def show_all_info(self):
        '''
        显示所有图书信息
        '''
        print(f"所有图书信息如下：")
        for b in self.__books:
            print(f"编号：{b.bid}，书名：{b.name}，价格：{b.price}，简介：{b.summary}")

    def save_data(self):
        '''
        保存数据
        '''
        #打开文件进行写入
        with open('data.txt', 'w', encoding='utf-8') as file:
            import sys
            original_stdout = sys.stdout
            sys.stdout = file
            self.show_all_info()
            sys.stdout = original_stdout
        print("信息已保存为data.txt")


    def load_data(self):
       '''
       加载数据
       :param self: 
       :return: 
       '''
       #打开文件进行读取
       with open('data.txt', 'r', encoding='utf-8') as file:
           content = file.read()
       print(content)

    # 管理方法
    def book_manager(self):
        '''
        图书管理系统流程管理函数
        '''
        while True:
            # 展示菜单
            select_op = self.__menu()
            # 判断用户选择的 1-8 之间的单个的数字
            if len(select_op) == 1 and select_op in "12345678":
                # 输入 1，完成添加图书的操作
                if select_op == "1":
                    # 接收用户输入的图书信息：编号、书名、价格、简介
                    bid = self.__get_bid()
                    name = self.__get_name()
                    price = self.__get_price()
                    summary = self.__get_summary()
                    # 调用添加图书的方法
                    self.add_book(bid, name, price, summary)
                # 输入 2，完成修改图书的操作
                elif select_op == "2":
                    # 接收用户输入的图书信息：编号
                    bid = self.__get_bid()
                    # 调用修改图书的函数
                    self.modify_book_by_id(bid)
                # 输入 3，完成通过编号删除图书的操作
                elif select_op == "3":
                    # 接收用户输入的图书信息：编号
                    bid = self.__get_bid()
                    # 调用对应的函数
                    self.delete_book_by_id(bid)
                # 输入 4，完成通过图书名删除图书的操作
                elif select_op == "4":
                    # 接收用户输入的图书信息：书名
                    name = self.__get_name()
                    self.delete_book_by_name(name)
                # 输入 5，完成通过编号查询图书信息
                elif select_op == "5":
                    # 接收用户输入的图书信息：编号
                    bid = self.__get_bid()
                    self.query_book_by_id(bid)
                # 输入 6，完成通过书名查询图书信息
                elif select_op == "6":
                    # 接收用户输入的图书信息：书名
                    name = self.__get_name()
                    self.query_book_by_name(name)
                # 输入 7，完成展示全部图书信息
                elif select_op == "7":
                    self.show_all_info()
                # 输入 8，退出系统
                elif select_op == "8":
                    self.save_data()
                    self.load_data()
                    break
            else:
                print("输入的数据不合法，请在菜单给定的数字中做出选择！！！")


if __name__ == '__main__':
    # 获取图书管理系统的实例
    bm = BookManager()
    # 再通过实例调用类中的实例方法
    bm.book_manager()
